#ifndef __CPoint__
#define __CPoint__

#include "../Basics/CCountedObject.hpp"
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace MathTools
	{
		/**
		 * @class CPoint CPoint.hpp
		 * @brief Representation of a position
		 *
		 * @date 19/09/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Added const == operator
		 * @version 1.0.2 Added isStraightLine method (either x's must match or the y's must match)
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CPoint.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CPoint : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construciton
			 * @param x The X Position
			 * @param y The Y Position
			 */
			CPoint(const long x = 0, const long y = 0);

			/**
			 * Copy construction
			 * @param point The point to copy
			 */
			CPoint(const CPoint &point);

			/**
			 * Destruction
			 */
			virtual ~CPoint();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param point The point to copy
			 * @retval CPoint& A reference to this
			 */
			CPoint &operator = (const CPoint &point);

			/**
			 * Equlity operator
			 * @param point The point to compare to
			 * @retval bool True if the points are the same, false otherwise
			 */
			bool operator == (const CPoint &point);

			/**
			 * Equlity operator
			 * @param point The point to compare to
			 * @retval bool True if the points are the same, false otherwise
			 */
			bool operator == (const CPoint &point) const;

			/**
			 * Offset the point with another point
			 * @param point The amount to offset by
			 */
			CPoint &operator += (const CPoint &point);

			/**
			 * Offset the point with another point
			 * @param point The amount to offset by
			 */
			CPoint &operator -= (const CPoint &point);

//	===========================================================================

			/**
			 * Set the entire position
			 * @param x The X Position
			 * @param y The Y Position
			 */
			void setPoint(const long x, const long y)
			{
				this->setXPosition(x);
				this->setYPosition(y);
			}

			/**
			 * Set the X Position
			 * @param x The X Position
			 */
			void setXPosition(const long x) { m_x = x; }

			/**
			 * Set the Y Position
			 * @param y The Y Position
			 */
			void setYPosition(const long y) { m_y = y; }

//	===========================================================================

			/**
			 * Get the x position
			 * @retval long The X Position
		     */
			long getXPosition() const { return m_x; }

			/**
			 * Get the y position
			 * @retval long The Y Position
			 */
			long getYPosition() const { return m_y; }

//	===========================================================================

			/**
			 * Offset the point with another point
			 * @param point The amount to offset by
			 */
			void offset(const CPoint &point);

			/**
			 * Offset by an amount
			 * @param x Amount to add to x position
			 * @param y Amount to add to y position
			 */
			void offset(const long x, const long y);

//	===========================================================================

			/**
			 * Is this a straight line
			 * @param point1 Starting point
			 * @param point2 Ending point
			 * @retval bool True if either p1.x==p2.x or p1.y==p2.y
			 */
			static bool isStraightLine(const CPoint &point1, const CPoint &point2);

//	===========================================================================

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const;

//	===========================================================================
			
		protected:

//	===========================================================================

			long m_x;			/**< X Position */
			long m_y;			/**< Y Position */
		};
	}
}
#endif	// End of CRect.hpp